﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="group">
    <div class="section">
      <div class="groupTitle">
        <xsl:value-of select="@title" />
      </div>
      <xsl:if test="(numericData or bitmaskData or optionData or textData) and not(multiBlock) and not (variableOffsetBlock) and not (group)">
        <div class="section">
          <div class="row">
            <div class="cellHeader">Data Type</div>
            <div class="cellHeader">Label</div>
            <div class="cellHeader">Offset</div>
            <div class="cellHeader">Length</div>
            <div class="cellHeader">Format/Bit/Options</div>
            <div class="cellHeader">File Index</div>
          </div>
          <xsl:apply-templates />
        </div>
      </xsl:if>
      <xsl:if test="not((numericData or bitmaskData or optionData or textData) and not(multiBlock) and not (variableOffsetBlock) and not (group))">
        <xsl:apply-templates />
      </xsl:if>
    </div>
  </xsl:template>
  <xsl:template match="numericData">
    <xsl:if test="../multiBlock or ../variableOffsetBlock or ../group">
      <div class="section">
        <div class="row">
          <div class="cellHeader">Data Type</div>
          <div class="cellHeader">Label</div>
          <div class="cellHeader">Offset</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format/Bit/Options</div>
          <div class="cellHeader">File Index</div>
        </div>
        <div class="row">
          <div class="cell">Numeric</div>
          <div class="cell"><xsl:value-of select="@label" /></div>
          <div class="cell"><xsl:value-of select="@offset" /></div>
          <div class="cell"><xsl:value-of select="@length" /></div>
          <div class="cell"><xsl:value-of select="@format" /></div>
          <xsl:if test="not(../blockItem) and not(../listItem)">
            <div class="cell"><xsl:value-of select="@source" /></div>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
    <xsl:if test="not(../multiBlock or ../variableOffsetBlock or ../group)">
      <div class="row">
        <div class="cell">Numeric</div>
        <div class="cell"><xsl:value-of select="@label" /></div>
        <div class="cell"><xsl:value-of select="@offset" /></div>
        <div class="cell"><xsl:value-of select="@length" /></div>
        <div class="cell"><xsl:value-of select="@format" /></div>
        <xsl:if test="not(../blockItem) and not(../listItem)">
          <div class="cell"><xsl:value-of select="@source" /></div>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template match="bitmaskData">
    <xsl:if test="../multiBlock or ../variableOffsetBlock or ../group">
      <div class="section">
        <div class="row">
          <div class="cellHeader">Data Type</div>
          <div class="cellHeader">Label</div>
          <div class="cellHeader">Offset</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format/Bit/Options</div>
          <div class="cellHeader">File Index</div>
        </div>
        <div class="row">
          <div class="cell">Bitmask</div>
          <div class="cell"><xsl:value-of select="@label" /></div>
          <div class="cell">
            <xsl:for-each select="bitmaskDataItem">
              <xsl:value-of select="@offset" /><br />
            </xsl:for-each>
          </div>
          <div class="cell">
            <xsl:for-each select="bitmaskDataItem">
              <xsl:value-of select="@length" /><br />
            </xsl:for-each>
          </div>
          <div class="cell">
            <xsl:for-each select="bitmaskDataItem">
              <xsl:if test="@bit">
                Bit: <xsl:value-of select="@bit" /><br />
              </xsl:if>
              <xsl:if test="@bits">
                Bits: <xsl:value-of select="@bits" />
                <xsl:if test="@labelOffset">
                  (Label Offset: <xsl:value-of select="@labelOffset" />)
                </xsl:if>
                <br />
              </xsl:if>
            </xsl:for-each>
          </div>
          <xsl:if test="not(../blockItem) and not(../listItem)">
            <div class="cell">
              <xsl:for-each select="bitmaskDataItem">
                <xsl:value-of select="@source" /><br />
              </xsl:for-each>
            </div>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
    <xsl:if test="not(../multiBlock or ../variableOffsetBlock or ../group)">
      <div class="row">
        <div class="cell">Bitmask</div>
        <div class="cell"><xsl:value-of select="@label" /></div>
        <div class="cell">
          <xsl:for-each select="bitmaskDataItem">
            <xsl:value-of select="@offset" /><br />
          </xsl:for-each>
        </div>
        <div class="cell">
          <xsl:for-each select="bitmaskDataItem">
            <xsl:value-of select="@length" /><br />
          </xsl:for-each>
        </div>
        <div class="cell">
          <xsl:for-each select="bitmaskDataItem">
            <xsl:if test="@bit">
              Bit: <xsl:value-of select="@bit" /><br />
            </xsl:if>
            <xsl:if test="@bits">
              Bits: <xsl:value-of select="@bits" />
              <xsl:if test="@labelOffset">
                (Label Offset: <xsl:value-of select="@labelOffset" />)
              </xsl:if>
              <br />
            </xsl:if>
          </xsl:for-each>
        </div>
        <xsl:if test="not(../blockItem) and not(../listItem)">
          <div class="cell">
            <xsl:for-each select="bitmaskDataItem">
              <xsl:value-of select="@source" /><br />
            </xsl:for-each>
          </div>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template match="optionData">
    <xsl:if test="../multiBlock or ../variableOffsetBlock or ../group">
      <div class="section">
        <div class="row">
          <div class="cellHeader">Data Type</div>
          <div class="cellHeader">Label</div>
          <div class="cellHeader">Offset</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format/Bit/Options</div>
          <div class="cellHeader">File Index</div>
        </div>
        <div class="row">
          <div class="cell">Option</div>
          <div class="cell">
            <xsl:for-each select="optionDataItem">
              <xsl:value-of select="@label" /><br />
            </xsl:for-each>
          </div>
          <div class="cell">
            <xsl:for-each select="optionDataItem">
              <xsl:value-of select="@offset" /><br />
            </xsl:for-each>
          </div>
          <div class="cell">
            <xsl:for-each select="optionDataItem">
              <xsl:value-of select="@length" /><br />
            </xsl:for-each>
          </div>
          <div class="cell">
            <xsl:for-each select="optionChoice">
              <xsl:value-of select="@value" />: <xsl:value-of select="@label" /><br />
            </xsl:for-each>
          </div>
          <xsl:if test="not(../blockItem) and not(../listItem)">
            <div class="cell">
              <xsl:for-each select="optionDataItem">
                <xsl:value-of select="@source" /><br />
              </xsl:for-each>
            </div>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
    <xsl:if test="not(../multiBlock or ../variableOffsetBlock or ../group)">
      <div class="row">
        <div class="cell">Option</div>
        <div class="cell">
          <xsl:for-each select="optionDataItem">
            <xsl:value-of select="@label" /><br />
          </xsl:for-each>
        </div>
        <div class="cell">
          <xsl:for-each select="optionDataItem">
            <xsl:value-of select="@offset" /><br />
          </xsl:for-each>
        </div>
        <div class="cell">
          <xsl:for-each select="optionDataItem">
            <xsl:value-of select="@length" /><br />
          </xsl:for-each>
        </div>
        <div class="cell">
          <xsl:for-each select="optionChoice">
            <xsl:value-of select="@value" />: <xsl:value-of select="@label" /><br />
          </xsl:for-each>
        </div>
        <xsl:if test="not(../blockItem) and not(../listItem)">
          <div class="cell">
            <xsl:for-each select="optionDataItem">
              <xsl:value-of select="@source" /><br />
            </xsl:for-each>
          </div>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template match="textData">
    <xsl:if test="../multiBlock or ../variableOffsetBlock or ../group">
      <div class="section">
        <div class="row">
          <div class="cellHeader">Data Type</div>
          <div class="cellHeader">Label</div>
          <div class="cellHeader">Offset</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format/Bit/Options</div>
          <div class="cellHeader">File Index</div>
        </div>
        <div class="row">
          <div class="cell">Text</div>
          <div class="cell"><xsl:value-of select="@label" /></div>
          <div class="cell"><xsl:value-of select="@offset" /></div>
          <div class="cell"><xsl:value-of select="@length" /></div>
          <div class="cell"><xsl:value-of select="@format" /></div>
          <xsl:if test="not(../blockItem) and not(../listItem)">
            <div class="cell"><xsl:value-of select="@source" /></div>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
    <xsl:if test="not(../multiBlock or ../variableOffsetBlock or ../group)">
      <div class="row">
        <div class="cell">Text</div>
        <div class="cell"><xsl:value-of select="@label" /></div>
        <div class="cell"><xsl:value-of select="@offset" /></div>
        <div class="cell"><xsl:value-of select="@length" /></div>
        <div class="cell"><xsl:value-of select="@format" /></div>
        <xsl:if test="not(../blockItem) and not(../listItem)">
          <div class="cell"><xsl:value-of select="@source" /></div>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template match="multiBlock">
    <div class="section">
        <div class="sectionTitle">
          Multi-block
        </div>
        <div class="section">
          <div class="row">
            <div class="cellHeader">Block Name</div>
            <div class="cellHeader">Offset</div>
            <div class="cellHeader">File Index</div>
          </div>
          <xsl:for-each select="blockItem">
            <div class="row">
              <div class="cell"><xsl:value-of select="@title" /></div>
              <div class="cell"><xsl:value-of select="@offset" /></div>
              <div class="cell"><xsl:value-of select="@source" /></div>
            </div>
          </xsl:for-each>
        </div>
        <div class="section">
          <div class="row">
            <div class="cellHeader">Data Type</div>
            <div class="cellHeader">Label</div>
            <div class="cellHeader">Relative Offset</div>
            <div class="cellHeader">Length</div>
            <div class="cellHeader">Format/Bit/Options</div>
          </div>
          <xsl:apply-templates />
        </div>
    </div>
  </xsl:template>
  <xsl:template match="variableOffsetBlock">
    <div class="section">
        <div class="sectionTitle">
          Variable Offset Block
        </div>
        <div class="row">
          <div class="cell">
            Base Offset: <xsl:value-of select="@baseOffset" />
          </div>
        </div>
        <div class="section">
          <div class="row">
            <div class="cellHeader">Offset Value Stored At Offset</div>
            <div class="cellHeader">Length</div>
            <div class="cellHeader">Cumulative?</div>
            <div class="cellHeader">File Index</div>
          </div>
          <xsl:for-each select="offsetItem">
            <div class="row">
              <div class="cell"><xsl:value-of select="@offset" /></div>
              <div class="cell"><xsl:value-of select="@length" /></div>
              <xsl:if test="@cumulative">
                <div class="cell">Y</div>
              </xsl:if>
              <xsl:if test="not(@cumulative)">
                <div class="cell">N</div>
              </xsl:if>
              <div class="cell"><xsl:value-of select="@source" /></div>
            </div>
          </xsl:for-each>
        </div>
        <div class="section">
          <xsl:if test="not(group)">
            <div class="row">
              <div class="cellHeader">Data Type</div>
              <div class="cellHeader">Label</div>
              <div class="cellHeader">Relative Offset</div>
              <div class="cellHeader">Length</div>
              <div class="cellHeader">Format/Bit/Options</div>
              <div class="cellHeader">File Index</div>
            </div>
          </xsl:if>
          <xsl:apply-templates />
        </div>
    </div>
  </xsl:template>
  <xsl:template match="listBlock">
    <div class="section">
      <div class="sectionTitle">
        List
      </div>
      <div class="row">
        <div class="cell">
          Offset: <xsl:value-of select="@offset" /><br />
          List Item Length: <xsl:value-of select="@listItemLength" /><br />
          <xsl:if test="@type">
            Type: <xsl:value-of select="@type" /><br />
          </xsl:if>
          <xsl:if test="not(@type)">
            Type: ordered<br />
          </xsl:if>
          <xsl:if test="@maxItems">
            Maximum Items: <xsl:value-of select="@maxItems" /><br />
          </xsl:if>
          <xsl:if test="@emptyItemId">
            Empty Item ID: <xsl:value-of select="@emptyItemId" /><br />
          </xsl:if>
          <xsl:if test="@defaultData">
            Default Empty Item Data: <xsl:value-of select="@defaultData" /><br />
          </xsl:if>
          File Index: <xsl:value-of select="@source" /><br />
          <xsl:for-each select="listCountDataItem">
            <br />
            List Count Data Item:<br />
            Offset: <xsl:value-of select="@offset" /><br />
            Length: <xsl:value-of select="@length" /><br />
            File Index: <xsl:value-of select="@source" /><br />
          </xsl:for-each>
          <xsl:for-each select="itemIdDataItem">
            <br />
            Item ID Data Item:<br />
            Relative Offset: <xsl:value-of select="@offset" /><br />
            Length: <xsl:value-of select="@length" /><br />
          </xsl:for-each>
        </div>
      </div>
      <div class="section">
        <div class="row">
          <div class="cellHeader">List Item</div>
          <div class="cellHeader">ID</div>
          <div class="cellHeader">Multiple Allowed?</div>
          <div class="cellHeader">Hidden?</div>
          <div class="cellHeader">Default Item Data</div>
        </div>
        <xsl:for-each select="listItem">
          <div class="row">
            <div class="cell"><xsl:value-of select="@label" /></div>
            <div class="cell"><xsl:value-of select="@id" /></div>
            <xsl:if test="@allowMultiple">
              <div class="cell">Y</div>
            </xsl:if>
            <xsl:if test="not(@allowMultiple)">
              <div class="cell">N</div>
            </xsl:if>
            <xsl:if test="@hidden">
              <div class="cell">Y</div>
            </xsl:if>
            <xsl:if test="not(@hidden)">
              <div class="cell">N</div>
            </xsl:if>
            <div class="cell"><xsl:value-of select="@defaultData" /></div>
          </div>
        </xsl:for-each>
      </div>
      <div class="section">
        <div class="row">
          <div class="cellHeader">Data Type</div>
          <div class="cellHeader">Label</div>
          <div class="cellHeader">Relative Offset</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format/Bit/Options</div>
        </div>
        <xsl:apply-templates />
      </div>
    </div>
  </xsl:template>
  <xsl:template match="/">
    <html>
    <head>
      <title>absurdlyobfuscated :: XXSE - <xsl:value-of select="/saveFileFormat/inputSource[1]/@titleName" /> Save File Format</title>
      <link rel="stylesheet" type="text/css" href="editor.css" />
    </head>
    <body>
    <h2>
      <xsl:value-of select="/saveFileFormat/inputSource[1]/@titleName" /> Save File Format
    </h2>
    <div class="section">
      <div class="sectionTitle">
        Files
      </div>
      <div class="section">
        <div class="row">
          <div class="cellHeader">File Name</div>
          <div class="cellHeader">Length</div>
          <div class="cellHeader">Format</div>
          <div class="cellHeader">Checksum</div>
          <div class="cellHeader">Magic Bytes</div>
          <div class="cellHeader">File Index</div>
        </div>
        <xsl:for-each select="/saveFileFormat/inputSource">
          <div class="row">
            <div class="cell"><xsl:value-of select="@name" /></div>
            <div class="cell"><xsl:value-of select="@length" /></div>
            <div class="cell"><xsl:value-of select="@format" /></div>
            <div class="cell">
              <xsl:if test="checksum">
                Checksum Type: <xsl:value-of select="checksum/@type" /><br />
                Position: <xsl:value-of select="checksum/@position" /><br />
                Start Offset: <xsl:value-of select="checksum/@startOffset" /><br />
                Length: <xsl:value-of select="checksum/@length" /><br />
                <xsl:if test="checksum/@defaultValue">
                  Default Checksum Value: <xsl:value-of select="checksum/@defaultValue" /><br />
                </xsl:if>
              </xsl:if>
            </div>
            <div class="cell">
              <xsl:if test="magicBytes">
                Position: <xsl:value-of select="magicBytes/@position" /><br />
                Length: <xsl:value-of select="magicBytes/@position" /><br />
                Value: <xsl:value-of select="magicBytes/@value" /><br />
              </xsl:if>
            </div>
            <div class="cell"><xsl:value-of select="@index" /></div>
          </div>
        </xsl:for-each>
      </div>
    </div>
    <xsl:apply-templates />
    </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
