﻿/* Checksum functions */
/* Contains md5, crc32, sha1, & adler32 */

/******************************************************************************/

function md5(input)
{
  function RotateLeft(lValue, iShiftBits)
  {
    return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
  }
  
  function AddUnsigned(lX, lY)
  {
    var lX4, lY4, lX8, lY8, lResult;
    lX8 = (lX & 0x80000000);
    lY8 = (lY & 0x80000000);
    lX4 = (lX & 0x40000000);
    lY4 = (lY & 0x40000000);
    lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
    if (lX4 & lY4) return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
    if (lX4 | lY4)
    {
      if (lResult & 0x40000000) return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
      else return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
    }
    else return (lResult ^ lX8 ^ lY8);
  }
  
  function F(x,y,z) { return (x & y) | ((~x) & z); }
  function G(x,y,z) { return (x & z) | (y & (~z)); }
  function H(x,y,z) { return (x ^ y ^ z); }
  function I(x,y,z) { return (y ^ (x | (~z))); }
  
  function FF(a, b, c, d, x, s, ac)
  {
    a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac));
    return AddUnsigned(RotateLeft(a, s), b);
  }
  
  function GG(a, b, c, d, x, s, ac)
  {
    a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac));
    return AddUnsigned(RotateLeft(a, s), b);
  }
  
  function HH(a, b, c, d, x, s, ac)
  {
    a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac));
    return AddUnsigned(RotateLeft(a, s), b);
  }
  
  function II(a, b, c, d, x, s, ac)
  {
    a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac));
    return AddUnsigned(RotateLeft(a, s), b);
  }
  
  function ConvertToWordArray(input)
  {
    var lWordCount;
    var lMessageLength = input.length;
    var lNumberOfWords_temp1 = lMessageLength + 8;
    var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
    var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
    var lWordArray = Array(lNumberOfWords - 1);
    var lBytePosition = 0;
    var lByteCount = 0;
    while (lByteCount < lMessageLength)
    {
      lWordCount = (lByteCount - (lByteCount % 4)) / 4;
      lBytePosition = (lByteCount % 4) * 8;
      lWordArray[lWordCount] = (lWordArray[lWordCount] | (input[lByteCount] << lBytePosition));
      lByteCount++;
    }
    lWordCount = (lByteCount - (lByteCount % 4)) / 4;
    lBytePosition = (lByteCount % 4) * 8;
    lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
    lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
    lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
    return lWordArray;
  }
  
  function ConvertToByteArray(word, length)
  {
    var i, byteArray = new Uint8Array(length);
    for (i = 0; i < length; i++)
    {
      byteArray[i] = word & 0xFF;
      word >>= 8;
    }
    return byteArray;
  }
  
  var x = new Array();
  var k, AA, BB, CC, DD, a, b, c, d;
  var S11 = 7, S12 = 12, S13 = 17, S14 = 22;
  var S21 = 5, S22 = 9 , S23 = 14, S24 = 20;
  var S31 = 4, S32 = 11, S33 = 16, S34 = 23;
  var S41 = 6, S42 = 10, S43 = 15, S44 = 21;
  var md5data = new Uint8Array(16);
  
  x = ConvertToWordArray(input);
  a = 0x67452301;
  b = 0xEFCDAB89;
  c = 0x98BADCFE;
  d = 0x10325476;
 
  for (k = 0; k < x.length; k += 16)
  {
    AA = a; BB = b; CC = c; DD = d;
    a = FF(a, b, c, d, x[k + 0],  S11, 0xD76AA478);
    d = FF(d, a, b, c, x[k + 1],  S12, 0xE8C7B756);
    c = FF(c, d, a, b, x[k + 2],  S13, 0x242070DB);
    b = FF(b, c, d, a, x[k + 3],  S14, 0xC1BDCEEE);
    a = FF(a, b, c, d, x[k + 4],  S11, 0xF57C0FAF);
    d = FF(d, a, b, c, x[k + 5],  S12, 0x4787C62A);
    c = FF(c, d, a, b, x[k + 6],  S13, 0xA8304613);
    b = FF(b, c, d, a, x[k + 7],  S14, 0xFD469501);
    a = FF(a, b, c, d, x[k + 8],  S11, 0x698098D8);
    d = FF(d, a, b, c, x[k + 9],  S12, 0x8B44F7AF);
    c = FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
    b = FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
    a = FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
    d = FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
    c = FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
    b = FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
    a = GG(a, b, c, d, x[k + 1],  S21, 0xF61E2562);
    d = GG(d, a, b, c, x[k + 6],  S22, 0xC040B340);
    c = GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
    b = GG(b, c, d, a, x[k + 0],  S24, 0xE9B6C7AA);
    a = GG(a, b, c, d, x[k + 5],  S21, 0xD62F105D);
    d = GG(d, a, b, c, x[k + 10], S22, 0x02441453);
    c = GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
    b = GG(b, c, d, a, x[k + 4],  S24, 0xE7D3FBC8);
    a = GG(a, b, c, d, x[k + 9],  S21, 0x21E1CDE6);
    d = GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
    c = GG(c, d, a, b, x[k + 3],  S23, 0xF4D50D87);
    b = GG(b, c, d, a, x[k + 8],  S24, 0x455A14ED);
    a = GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
    d = GG(d, a, b, c, x[k + 2],  S22, 0xFCEFA3F8);
    c = GG(c, d, a, b, x[k + 7],  S23, 0x676F02D9);
    b = GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
    a = HH(a, b, c, d, x[k + 5],  S31, 0xFFFA3942);
    d = HH(d, a, b, c, x[k + 8],  S32, 0x8771F681);
    c = HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
    b = HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
    a = HH(a, b, c, d, x[k + 1],  S31, 0xA4BEEA44);
    d = HH(d, a, b, c, x[k + 4],  S32, 0x4BDECFA9);
    c = HH(c, d, a, b, x[k + 7],  S33, 0xF6BB4B60);
    b = HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
    a = HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
    d = HH(d, a, b, c, x[k + 0],  S32, 0xEAA127FA);
    c = HH(c, d, a, b, x[k + 3],  S33, 0xD4EF3085);
    b = HH(b, c, d, a, x[k + 6],  S34, 0x04881D05);
    a = HH(a, b, c, d, x[k + 9],  S31, 0xD9D4D039);
    d = HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
    c = HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
    b = HH(b, c, d, a, x[k + 2],  S34, 0xC4AC5665);
    a = II(a, b, c, d, x[k + 0],  S41, 0xF4292244);
    d = II(d, a, b, c, x[k + 7],  S42, 0x432AFF97);
    c = II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
    b = II(b, c, d, a, x[k + 5],  S44, 0xFC93A039);
    a = II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
    d = II(d, a, b, c, x[k + 3],  S42, 0x8F0CCC92);
    c = II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
    b = II(b, c, d, a, x[k + 1],  S44, 0x85845DD1);
    a = II(a, b, c, d, x[k + 8],  S41, 0x6FA87E4F);
    d = II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
    c = II(c, d, a, b, x[k + 6],  S43, 0xA3014314);
    b = II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
    a = II(a, b, c, d, x[k + 4],  S41, 0xF7537E82);
    d = II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
    c = II(c, d, a, b, x[k + 2],  S43, 0x2AD7D2BB);
    b = II(b, c, d, a, x[k + 9],  S44, 0xEB86D391);
    a = AddUnsigned(a, AA);
    b = AddUnsigned(b, BB);
    c = AddUnsigned(c, CC);
    d = AddUnsigned(d, DD);
  }
  
  md5data.set(ConvertToByteArray(a, 4));
  md5data.set(ConvertToByteArray(b, 4), 4);
  md5data.set(ConvertToByteArray(c, 4), 8);
  md5data.set(ConvertToByteArray(d, 4), 12);
  return md5data;
}

/******************************************************************************/

function crc32(input)
{
  var table = [0x00000000, 0x77073096, 0xEE0E612C, 0x990951BA, 0x076DC419, 0x706AF48F, 0xE963A535, 0x9E6495A3, 0x0EDB8832, 0x79DCB8A4, 0xE0D5E91E, 0x97D2D988, 0x09B64C2B, 0x7EB17CBD, 0xE7B82D07, 0x90BF1D91, 0x1DB71064, 0x6AB020F2, 0xF3B97148, 0x84BE41DE, 0x1ADAD47D, 0x6DDDE4EB, 0xF4D4B551, 0x83D385C7, 0x136C9856, 0x646BA8C0, 0xFD62F97A, 0x8A65C9EC, 0x14015C4F, 0x63066CD9, 0xFA0F3D63, 0x8D080DF5, 0x3B6E20C8, 0x4C69105E, 0xD56041E4, 0xA2677172, 0x3C03E4D1, 0x4B04D447, 0xD20D85FD, 0xA50AB56B, 0x35B5A8FA, 0x42B2986C, 0xDBBBC9D6, 0xACBCF940, 0x32D86CE3, 0x45DF5C75, 0xDCD60DCF, 0xABD13D59, 0x26D930AC, 0x51DE003A, 0xC8D75180, 0xBFD06116, 0x21B4F4B5, 0x56B3C423, 0xCFBA9599, 0xB8BDA50F, 0x2802B89E, 0x5F058808, 0xC60CD9B2, 0xB10BE924, 0x2F6F7C87, 0x58684C11, 0xC1611DAB, 0xB6662D3D, 0x76DC4190, 0x01DB7106, 0x98D220BC, 0xEFD5102A, 0x71B18589, 0x06B6B51F, 0x9FBFE4A5, 0xE8B8D433, 0x7807C9A2, 0x0F00F934, 0x9609A88E, 0xE10E9818, 0x7F6A0DBB, 0x086D3D2D, 0x91646C97, 0xE6635C01, 0x6B6B51F4, 0x1C6C6162, 0x856530D8, 0xF262004E, 0x6C0695ED, 0x1B01A57B, 0x8208F4C1, 0xF50FC457, 0x65B0D9C6, 0x12B7E950, 0x8BBEB8EA, 0xFCB9887C, 0x62DD1DDF, 0x15DA2D49, 0x8CD37CF3, 0xFBD44C65, 0x4DB26158, 0x3AB551CE, 0xA3BC0074, 0xD4BB30E2, 0x4ADFA541, 0x3DD895D7, 0xA4D1C46D, 0xD3D6F4FB, 0x4369E96A, 0x346ED9FC, 0xAD678846, 0xDA60B8D0, 0x44042D73, 0x33031DE5, 0xAA0A4C5F, 0xDD0D7CC9, 0x5005713C, 0x270241AA, 0xBE0B1010, 0xC90C2086, 0x5768B525, 0x206F85B3, 0xB966D409, 0xCE61E49F, 0x5EDEF90E, 0x29D9C998, 0xB0D09822, 0xC7D7A8B4, 0x59B33D17, 0x2EB40D81, 0xB7BD5C3B, 0xC0BA6CAD, 0xEDB88320, 0x9ABFB3B6, 0x03B6E20C, 0x74B1D29A, 0xEAD54739, 0x9DD277AF, 0x04DB2615, 0x73DC1683, 0xE3630B12, 0x94643B84, 0x0D6D6A3E, 0x7A6A5AA8, 0xE40ECF0B, 0x9309FF9D, 0x0A00AE27, 0x7D079EB1, 0xF00F9344, 0x8708A3D2, 0x1E01F268, 0x6906C2FE, 0xF762575D, 0x806567CB, 0x196C3671, 0x6E6B06E7, 0xFED41B76, 0x89D32BE0, 0x10DA7A5A, 0x67DD4ACC, 0xF9B9DF6F, 0x8EBEEFF9, 0x17B7BE43, 0x60B08ED5, 0xD6D6A3E8, 0xA1D1937E, 0x38D8C2C4, 0x4FDFF252, 0xD1BB67F1, 0xA6BC5767, 0x3FB506DD, 0x48B2364B, 0xD80D2BDA, 0xAF0A1B4C, 0x36034AF6, 0x41047A60, 0xDF60EFC3, 0xA867DF55, 0x316E8EEF, 0x4669BE79, 0xCB61B38C, 0xBC66831A, 0x256FD2A0, 0x5268E236, 0xCC0C7795, 0xBB0B4703, 0x220216B9, 0x5505262F, 0xC5BA3BBE, 0xB2BD0B28, 0x2BB45A92, 0x5CB36A04, 0xC2D7FFA7, 0xB5D0CF31, 0x2CD99E8B, 0x5BDEAE1D, 0x9B64C2B0, 0xEC63F226, 0x756AA39C, 0x026D930A, 0x9C0906A9, 0xEB0E363F, 0x72076785, 0x05005713, 0x95BF4A82, 0xE2B87A14, 0x7BB12BAE, 0x0CB61B38, 0x92D28E9B, 0xE5D5BE0D, 0x7CDCEFB7, 0x0BDBDF21, 0x86D3D2D4, 0xF1D4E242, 0x68DDB3F8, 0x1FDA836E, 0x81BE16CD, 0xF6B9265B, 0x6FB077E1, 0x18B74777, 0x88085AE6, 0xFF0F6A70, 0x66063BCA, 0x11010B5C, 0x8F659EFF, 0xF862AE69, 0x616BFFD3, 0x166CCF45, 0xA00AE278, 0xD70DD2EE, 0x4E048354, 0x3903B3C2, 0xA7672661, 0xD06016F7, 0x4969474D, 0x3E6E77DB, 0xAED16A4A, 0xD9D65ADC, 0x40DF0B66, 0x37D83BF0, 0xA9BCAE53, 0xDEBB9EC5, 0x47B2CF7F, 0x30B5FFE9, 0xBDBDF21C, 0xCABAC28A, 0x53B39330, 0x24B4A3A6, 0xBAD03605, 0xCDD70693, 0x54DE5729, 0x23D967BF, 0xB3667A2E, 0xC4614AB8, 0x5D681B02, 0x2A6F2B94, 0xB40BBE37, 0xC30C8EA1, 0x5A05DF1B, 0x2D02EF8D];
  var crc = 0xFFFFFFFF;
  for(var i = 0; i < input.length; i++)
  {
    crc = (crc >>> 8) ^ table[(crc ^ input[i]) & 0xFF];
  }
  return crc ^ 0xFFFFFFFF;
}

/******************************************************************************/

/**
*
*  Secure Hash Algorithm (SHA1)
*  http://www.webtoolkit.info/
*
**/
 
function sha1(input)
{
 
  function rotate_left(n,s)
  {
    var t4 = (n << s) | (n >>> (32 - s));
    return t4;
  }
  
  function lsb_hex(val)
  {
    var str="";
    var i;
    var vh;
    var vl;
    
    for(i = 0; i <= 6; i += 2)
    {
      vh = (val >>> (i * 4 + 4)) & 0x0F;
      vl = (val >>> (i * 4)) & 0x0F;
      str += vh.toString(16) + vl.toString(16);
    }
    return str;
  }
  
  function toByteArray(value, length)
  {
    var i, byteArray = new Uint8Array(length);
    for (i = 0; i < length; i++)
    {
      byteArray[length - i - 1] = value & 0xFF;
      value >>= 8;
    }
    return byteArray;
  }
  
  var blockstart;
  var i, j;
  var W = new Array(80);
  var H0 = 0x67452301;
  var H1 = 0xEFCDAB89;
  var H2 = 0x98BADCFE;
  var H3 = 0x10325476;
  var H4 = 0xC3D2E1F0;
  var A, B, C, D, E;
  var temp;
  var msg_len = input.length;
  var word_array = new Array();
  var sha1data = new Uint8Array(20);
  
  for(i = 0; i < msg_len - 3; i += 4)
  {
    j = input[i] << 24 | input[i + 1] << 16 | input[i + 2] << 8 | input[i + 3];
    word_array.push(j);
  }
  
  switch(msg_len % 4)
  {
    case 0:
      i = 0x080000000;
      break;
    
    case 1:
      i = input[msg_len - 1] << 24 | 0x0800000;
      break;
    
    case 2:
      i = input[msg_len - 2] << 24 | input[msg_len - 1] << 16 | 0x08000;
      break;
    
    case 3:
      i = input[msg_len - 3] << 24 | input[msg_len - 2] << 16 | input[msg_len - 1] << 8 | 0x80;
      break;
  }
  
  word_array.push(i);
  
  while((word_array.length % 16) != 14) word_array.push(0);
  
  word_array.push(msg_len >>> 29);
  word_array.push((msg_len << 3) & 0x0FFFFFFFF);
  
  for (blockstart = 0; blockstart < word_array.length; blockstart += 16)
  {
    for(i = 0; i < 16; i++) W[i] = word_array[blockstart + i];
    for(i = 16; i <= 79; i++) W[i] = rotate_left(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);
    
    A = H0;
    B = H1;
    C = H2;
    D = H3;
    E = H4;
    
    for(i = 0; i <= 19; i++)
    {
      temp = (rotate_left(A, 5) + ((B & C) | (~B & D)) + E + W[i] + 0x5A827999) & 0x0FFFFFFFF;
      E = D;
      D = C;
      C = rotate_left(B, 30);
      B = A;
      A = temp;
    }
    
    for(i = 20; i <= 39; i++ )
    {
      temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0x6ED9EBA1) & 0x0FFFFFFFF;
      E = D;
      D = C;
      C = rotate_left(B, 30);
      B = A;
      A = temp;
    }
    
    for(i = 40; i <= 59; i++)
    {
      temp = (rotate_left(A, 5) + ((B & C) | (B & D) | (C & D)) + E + W[i] + 0x8F1BBCDC) & 0x0FFFFFFFF;
      E = D;
      D = C;
      C = rotate_left(B, 30);
      B = A;
      A = temp;
    }
    
    for(i = 60; i <= 79; i++)
    {
      temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0xCA62C1D6) & 0x0FFFFFFFF;
      E = D;
      D = C;
      C = rotate_left(B, 30);
      B = A;
      A = temp;
    }
    
    H0 = (H0 + A) & 0x0FFFFFFFF;
    H1 = (H1 + B) & 0x0FFFFFFFF;
    H2 = (H2 + C) & 0x0FFFFFFFF;
    H3 = (H3 + D) & 0x0FFFFFFFF;
    H4 = (H4 + E) & 0x0FFFFFFFF;
    
  }
  
  sha1data.set(toByteArray(H0, 4));
  sha1data.set(toByteArray(H1, 4), 4);
  sha1data.set(toByteArray(H2, 4), 8);
  sha1data.set(toByteArray(H3, 4), 12);
  sha1data.set(toByteArray(H4, 4), 16);
  return sha1data;
}

/******************************************************************************/

function adler32(input)
{
  for (var b = 65521, c = 1, d = 0, e = 0, f; f = input[e++]; d = (d + c) % b)
  {
    c = (c + f) % b;
  }
  return (d << 16) | c;
}
